% This file generates figures for the Nikon D100
close all; clear all; clc;

% Get the data file
load NikonD100.mat


% Get the colors
%red_wl = wavelength(find(data(:,1) == max(data(:, 1))));

red_wl = nearest( sum(data(:,1) .* wavelength) / sum(data(:,1))  * 1.1);
green_wl = wavelength(find(data(:,2) == max(data(:, 2))));
blue_wl = wavelength(find(data(:,3) == max(data(:, 3))));

[r_r,r_g,r_b] = WavelengthToRGB(red_wl);
[g_r,g_g,g_b] = WavelengthToRGB(green_wl);
[b_r,b_g,b_b] = WavelengthToRGB(blue_wl);


% Plot the filter spectra
figure(1);
plot(wavelength, data(:,1), 'LineWidth', 2,  'Color', [r_r r_g r_b]);
hold on;
plot(wavelength, data(:,2), 'LineWidth', 2,  'Color', [g_r g_g g_b]);
plot(wavelength, data(:,3), 'LineWidth', 2,  'Color', [b_r b_g b_b]);
plot(wavelength, sum(data,2), 'k--', 'LineWidth', 2);
xlabel('Wavelength (nm)');
ylabel('Transmittance');
title('Transmittance of Nikon D100''s Sensor Filters');
xlim([380 710]);
ylim([0 1.1*max(sum(data,2))]);
grid on;
saveas(gcf, 'NikonD100_Spectra2.eps', 'epsc2');


% Plot the Sensor Array
sensorColorArray = zeros([2,2,3]);
sensorColorArray(1,1,1) = g_r;
sensorColorArray(1,1,2) = g_g;
sensorColorArray(1,1,3) = g_b;

sensorColorArray(1,2,1) = b_r;
sensorColorArray(1,2,2) = b_g;
sensorColorArray(1,2,3) = b_b;

sensorColorArray(2,1,1) = r_r;
sensorColorArray(2,1,2) = r_g;
sensorColorArray(2,1,3) = r_b;

sensorColorArray(2,2,1) = g_r;
sensorColorArray(2,2,2) = g_g;
sensorColorArray(2,2,3) = g_b;

figure(2);
sensorColorArray = imresize(sensorColorArray, [60,60], 'nearest');
imagesc(sensorColorArray, [0,1]);
title('Pattern for Nikon D100');
%{
for ii = 1:size(p,1),
   for jj = 1:size(p,2),
      ypos = 20*ii - 10;
      xpos = 20*jj - 10;
      text(xpos, ypos, [num2str(cPos(p(ii,jj))) ' nm'], 'HorizontalAlignment', 'center');
   end
end
%}
axis image;
axis off;
saveas(gcf, 'NikonD100_CFA.eps', 'epsc2');

% End of File
